/*pcdcount.c
12/12/02

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

Description:
A C program for controlling 
the counters of the pcde12

ex:
setup command
pcdcount c num trigger threshold

read command
pcdcount r num

*/

#include "counter.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>


int zeros = 0;
volatile int waiting = 1;

static int help(void)
{
const char *help_table = "**********************************************
*pcdcount                                    *
*12/12/02 Nathan Z. Gustavson                *
*Emac.inc                                    * 
*                                            *   
*usage:                                      *   
*reading                                     *
*pcdcount r counter                          *
*setup                                       *   
*pcdcount s counter rise/fall/both threshold *
*control                                     *
*pcdcount c counter start/stop/signal/nosig  *
*load                                        *
*pcdcount l counter value                    *
*zerocounter                                 *
*pcdcount z counter rise/fall/both threshold *
*countdown                                   * 
*pcdcount d counter rise/fall/both threshold *
**********************************************\n";


printf("%s",help_table);


return 0;
}

#define ARGCHECK(num){if(argc<num){printf("invalid number of arguements\n");help();return -1;}}


/*signal handlers
for async IO settings z and d
respectively
*/
static void zero_counter(int signal){
printf("zeros = %u\n",++zeros);
}


static void terminate(int signal){
printf("countdown terminated\n");
waiting = 0;
}


static __u16 get_trigger(char *string)
{
if(!strcmp(string,"rise"))
   return RISEE;
if(!strcmp(string,"fall"))
   return FALLE;
if(!strcmp(string,"both"))
   return ANYE;

   return NOE;

}


static __u16 get_command(char *string)
{
if(!strcmp(string,"start"))
   return ICSTART;
if(!strcmp(string,"stop"))
   return ICSTOP;
if(!strcmp(string,"signal"))
   return ICNOTIFYON;
if(!strcmp(string,"nosig"))
   return ICNOTIFYOFF;


   return NULLCOMMAND;

}





int main(int argc,char **argv)
{
countconfig config;
int counter,fd;
__u16 count;
char command;
char device[20];
__u16 threshold;
long oflags;
struct sigaction zero_signal;


ARGCHECK(3);

command = *argv[1];
counter=strtoul(argv[2],NULL,0);

if((counter>7)||(counter<0))
  {
printf("invalid counter\n");
return -1;
  }

switch(command)
  {
  case 'r'://read command
    sprintf(device,"/dev/count%x",counter);
    
    if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }


    if(read(fd,&count,2)!=2)
      {
	printf("couldn't read from %s\n",device);
	return -1;
      }

    printf("%x\n",count);
    close(fd);
    break;


  case 's'://setup command
  
  ARGCHECK(5);

  config.counter = counter;

  if(!(config.trigger=get_trigger(argv[3])))
    {
      printf("invalid trigger %s\n",argv[4]);
      return -1;
    }

 if((config.threshold=strtoul(argv[4],NULL,0)))
   config.flags = AUTOLOAD;
 else
   config.flags = 0;

   
   if((fd = open("/dev/dig1", O_RDWR))<=0)
     {
       printf("couldn't open /dev/dig1\n");
       return -1;
     }
  
   ioctl(fd,PCD_COUNT,&config);//pass counter configuration structure to digital port

   close(fd);

   break;
 
  case 'c'://control 
//printf("control packet\n");
    ARGCHECK(4);

sprintf(device,"/dev/count%x",counter);    

if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }  
    ioctl(fd,get_command(argv[3]),NULL);
//printf("ioctl called\n");
    close(fd);

    break;


  case 'l':
    ARGCHECK(4);
sprintf(device,"/dev/count%x",counter);    

if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }  

threshold = (__u16)strtoul(argv[3],NULL,0);

write(fd,&threshold,sizeof(threshold));

close(fd);

break;

  case 'z':

//configure counter with asychronous notification flag
 ARGCHECK(5);

  config.counter = counter;

  if(!(config.trigger=get_trigger(argv[3])))
    {
      printf("invalid trigger %s\n",argv[4]);
      return -1;
    }

 if((config.threshold=strtoul(argv[4],NULL,0)))
   config.flags = AUTOLOAD|ANOTE;
 else
   config.flags = ANOTE;
 


   if((fd = open("/dev/dig1", O_RDWR))<=0)
     {
       printf("couldn't open /dev/dig1\n");
       return -1;
     }
  
   ioctl(fd,PCD_COUNT,&config);//pass counter configuration structure to digital port

close(fd);

sprintf(device,"/dev/count%x",counter);    

if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }  

printf("Initializing \n");

sleep(2);//flush any pending signals

zero_signal.sa_handler = zero_counter;

sigaction(SIGIO, &zero_signal,NULL); //install signal handler
fcntl(fd, F_SETOWN,getpid()); //set signal ownership
oflags = fcntl(fd, F_GETFL); //get current flags
fcntl(fd,F_SETFL, oflags|FASYNC);//add FASYNC flag to them


printf("hit Cntrl-C to exit\n");

ioctl(fd,ICSTART,NULL);//start counter


while(1); //let signal handlers work;


    break;

  case 'd':
 ARGCHECK(5);

  config.counter = counter;

  if(!(config.trigger=get_trigger(argv[3])))
    {
      printf("invalid trigger %s\n",argv[4]);
      return -1;
    }

 if((config.threshold=strtoul(argv[4],NULL,0)))
   config.flags = AUTOLOAD|ANOTE|AUTOSTOP;
 else
   config.flags = ANOTE|AUTOSTOP;
 


   if((fd = open("/dev/dig1", O_RDWR))<=0)
     {
       printf("couldn't open /dev/dig1\n");
       return -1;
     }
  
   ioctl(fd,PCD_COUNT,&config);//pass counter configuration structure to digital port

close(fd);

sprintf(device,"/dev/count%x",counter);    

if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }  

printf("Initializing \n");

sleep(2);//flush any pending signals

zero_signal.sa_handler = terminate;

sigaction(SIGIO, &zero_signal,NULL); //install signal handler
fcntl(fd, F_SETOWN,getpid()); //set signal ownership
oflags = fcntl(fd, F_GETFL); //get current flags
fcntl(fd,F_SETFL, oflags|FASYNC);//add FASYNC flag to them



//printf("hit Cntrl-C to exit\n");

printf("starting counter\n");
ioctl(fd,ICSTART,NULL);//start counter


while(waiting); //let signal handlers work;

    break;

  }

  

close(fd);

return 0;
}







