/*
pcdcan_config.c
1/07/03
Nathan Z. Gustavson ngustavson@emacinc.com
Emac.inc
www.emacinc.com
*/
#include "counter.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include "pcdcan.h"


static int help(void)
{
const char *help_table = "**********************************************
*pcdcan_config.c                             *
*Nathan Z. Gustavson                         *
*Emac.inc                                    * 
*"__DATE__"                                 *   
*usage:                                      *   
*pcdcan_config device baud mask id           *
*ex:                                         *
*pcdcan_config can0 250 0xffff 0xffff        *   
**********************************************\n";
printf("%s",help_table);
return 0;
}

#define ARGCHECK(num){if(argc<num){printf("invalid number of arguements\n");help();return -1;}}

int main(int argc,char **argv)
{
char device[20];
int fd;
Canconfig config;

ARGCHECK(5);

sprintf(device,"/dev/%s",argv[1]);

if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }  

config.baud = strtoul(argv[2],NULL,0);
config.mask = strtoul(argv[3],NULL,0);
config.id = strtoul(argv[4],NULL,0);

ioctl(fd,0,&config);

printf("%s configured\n",device);

close(fd);
return 0;
}
