/*
pcd232_config.c
1/08/03
Nathan Z. Gustavson ngustavson@emacinc.com
Emac.inc
www.emacinc.com
*/

#include "counter.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include "pcdser.h"


#define ARGCHECK(num){if(argc!=num){printf("invalid number of arguements\n");help();return -1;}}

static int help(void)
{
const char *help_table = "**********************************************
*pcd232_config.c                             *
*Nathan Z. Gustavson                         *
*Emac.inc                                    * 
*"__DATE__"                                 *   
*usage:                                      *   
*pcd232_config baud                          *
*ex:                                         *
*pcd232_config 9600                          *   
**********************************************\n";
printf("%s",help_table);
return 0;
}




int main(int argc,char **argv)
{
char *device = "/dev/PCD232";
int fd;
Serconfig config;

ARGCHECK(2);


if((fd = open(device, O_RDWR))<=0)
     {
       printf("couldn't open %s\n",device);
       return -1;
     }  

config.baud = strtoul(argv[1],NULL,0);
config.mode = EIGHT_BIT;


ioctl(fd,0,&config);

printf("%s configured\n",device);

close(fd);
return 0;
}


