/*counter.h
12/12/02

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

struct types and definitions for pcde12 counter programming

*/

#include <sys/types.h>
#include <asm/types.h>


/*IC modes*/
#define NOE   0  /*no input capture*/
#define RISEE 1 /*rising edge*/
#define FALLE 2 /*falling edge*/
#define ANYE 3 /*any edge*/


/*ioctl counter command codes*/
#define ICSTART		0
#define ICSTOP		1
#define ICNOTIFYON	2
#define ICNOTIFYOFF 	3
#define NULLCOMMAND     4

/*ioctl digital port configuration*/
#define  PCD_COUNT      2


/*configuration flags*/
#define ANOTE 1 //notify countdown hits zero
#define AUTOLOAD 2 //autoload threshold value when decrementing from zero
#define AUTOSTOP 4 //stop counter when zero is reached

typedef struct countconfig{
__u16 counter;
__u16 trigger;
__u16 threshold;
__u16 flags;
}countconfig;

