#ifdef __cplusplus
#define EXPORT extern "C" __declspec (dllexport)
#else
#define EXPORT __declspec (dllexport)
#endif

//*********************************************************************
//
//BOOL PCDInitialize(void);			//passed parameters (0)
//
//Pre: The PCD Driver Driver must be Closed
//
//Post:
//	The PCD Driver will be initialized upon Returning (TRUE)(1)
//	(SUCCESS)
//
//	The PCD Driver will not be initialized upon Returning (FALSE)(0)
//	(FAILURE)
//
//Description:
//	A Call to this function will initialize the PCD Device Driver
//
//*********************************************************************
//
//BOOL PCDOpen(void);				//passed parameters (0)
//
//Pre:	The Device must be Closed.
//		The Device must be Initialized
//
//Post:
//	The PCD Driver will be open upon Returning (TRUE)(1)
//	(SUCCESS)
//
//	The PCD Driver will not be open upon Returning (FALSE)(0)
//	(FAILURE)
//
//
//Description:
//
//		A successful return from this function will result in the 
//		open state of the PCD and make it available for Read/Write 
//		operations.
//
//
//*********************************************************************
//
//BOOL PCDClose(void);				//passed parameters (0)
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//
//Post:
//	The PCD Driver will be closed upon Returning (TRUE)(1)
//	(SUCCESS)
//
//	The PCD Driver will not be closed upon Returning (FALSE)(0)
//	(FAILURE)
//
//
//Description:
//
//		A successful return from this function will result in the 
//		closed state of the PCD and free driver allocated memory.
//
//*********************************************************************
//BOOL PCDSetDigitalPort(int Block,		//Block 0
//int Channel,							//Channel 0-1
//BYTE Value);							//Value 8-bit 
//									
//
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized.
//Post:
//	The PCD Driver sucessfully loaded Block,Channel,Value upon 
//	Returning (TRUE),(1),(SUCCESS).
//
//	The PCD Driver failed to load Block,Channel,Value upon 
//	Returning (FALSE),(0),(FAILURE).
//
//Description:
// This function currently supports one Block and two channels.
// A modification will be made to output pins only. 
//
//*********************************************************************
//BOOL PCDSendRaw(PUCHAR pSourceBytes, 	  //(unsigned char *) to 
//										  //array of characters or
//										  //unsigned char string 
//										  //name
//
//ULONG NumberOfBytes);				  //unsigned long number of
//									  //bytes to send Raw Data
//							  
//
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	The PCD Driver sucessfully loaded Source Bytes upon Returning 
//	(TRUE),(1),(SUCCESS).
//
//	The PCD Driver failed to load Source Bytes upon Returning 
//	(FALSE),(0),(FAILURE).
//
//Description:
//	
//	This function sends a user defined number of raw data bytes to 
//	the PCD.
//
//	Note:This function is used for testing purposes only and is not
//	supported by the protocol driver.
//
//*********************************************************************
//BOOL PCDSend2LCD(PUCHAR pSourceBytes, 	   //(unsigned char *) to 
//							   //array of characters or 
//							   //unsigned char string 
//							   //name
//
//ULONG NumberOfBytes);			//unsigned long number of 
//							   //bytes to send to LCD
//							   
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	The PCD Driver sucessfully loaded Source Bytes upon Returning 
//	(TRUE),(1),(SUCCESS).
//
//	The PCD Driver failed to load Source Bytes upon Returning 
//	(FALSE),(0),(FAILURE).
//
//Description
//		This function sends a user defined number of data bytes to 
//		the LCD.
//
//*********************************************************************
//ULONG PCDGetKeypad(PUCHAR pTargetBuffer,   //(unsigned char *) to 
//							   //array of characters or 
//							   //unsigned char string 
//							   //name
//
//ULONG BufferLength);		   //unsigned long number of 
//							   //bytes to recieve from 
//							   //keypad 
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//
//Post:
//	Returns a unsigned long number of bytes that was put into
//	pTargetBuffer
//
//Description
//		This function gets a user defined number of data bytes from 
//		the keypad and puts the data into the pTargetBuffer.
// 
//		
//*********************************************************************
//WORD PCDGetA2DPort(int Block,		//Block 0 0-15 Channels
//									//Block 1 0-7  Channels
//int Channel);
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//		PCD Returns a 16 bit unsigned short integer representing 
//		the user defined Block and Channel.
//
//Description:
//		The PCD Driver Returns a 16 bit unsigned short integer
//		representing the user defined Block and Channel.
//		Block 0 has 16 Channels and Block 1 has 8 Channels.
//
//*********************************************************************
//BYTE PCDGetDigitalPort(int Block,
//int Channel);
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	Returns a  8 bit unsigned char.
//
//Description:
//*********************************************************************
//WORD PCDGetCounter(int Block,
//int Channel);
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//
//Post:
//	Returns a 16 bit unsigned short integer.
//
//
//Description
//		This function is not yet defined or implemented
//*********************************************************************
//ULONG PCDGetRaw(PUCHAR pTargetBuffer,	//(unsigned char *) to 
//							//array of characters or 
//							//unsigned char string 
//							//name
//
//ULONG BufferLength);				//unsigned long number of
//							//bytes to recieve from 
//							//keypad 
//
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	Returns a unsigned long number of bytes that was put into
//	pTargetBuffer
//
//Description
//		This function gets a user defined number of data bytes from 
//		the PCD and puts the data into the pTargetBuffer.
//
//	Note:This function is used for testing purposes only and is not
//	supported by the protocol driver. 
//
//*********************************************************************
//BOOL PCDSendSerialPort(PUCHAR pSourceBytes, //(unsigned char *) to 
//							    //array of characters or 
//							    //unsigned char string 
//							    //name
//
//ULONG NumberOfBytes);				    //unsigned long number of 
//							    //bytes to send to serial 
//							    //port
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//
//Post:
//	The PCD Driver successfuly sent user defined number bytes and
//	load them from the pSourceBytes Buffer upon Returning
//	(TRUE)(1)(SUCCESS)
//
//	The PCD Driver failed to send user defined number bytes and
//	load them from the pSourceBytes Buffer upon Returning
//	(FALSE)(0)(FAILURE)
//
//Description:
//		This function gets a user defined number of data bytes from 
//		the PCD serial port and puts the data into the 
//		pTargetBuffer.
//*********************************************************************
//BOOL PCDGetSerialPort(PUCHAR pTargetBuffer,	//(unsigned char *) to 
//								//array of characters 
//								//or unsigned char
//								//string name
//							
//							 
//
//ULONG BufferLength);				//unsigned long number of
//							//bytes to recieve from 
//							//serial port 
//
//
//
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//
//Post:
//	The PCD Driver successfuly recieved user defined number bytes and 
//	loaded them into the PTargetBuffer upon Returning
//	(TRUE)(1)(SUCCESS)
//
//	The PCD Driver failed to recieve user defined number bytes and
//	load them into the PTargetBuffer upon Returning
//	(FALSE)(0)(FAILURE)
//
//
//Description:
//		This function gets a user defined number of data bytes from 
//		the PCD serial port and puts the data into the 
//		pTargetBuffer.
// 
//*********************************************************************
//BOOL PCDSetPWMPort(int Block,		//Block	0-3
//int Channel,						//Channel	0-3
//int Frequency,					//Frequency	0-100kHz
//int DutyCycle,					//DutyCycle 0-100%
//int Delay);						//Delay	0-65,535 
//									//Milliseconds
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	 upon Returning (TRUE)(1)
//	(SUCCESS)
//
//	 upon Returning (FALSE)(0)
//	(FAILURE)
//
//Description:
//	This function sets the Frequency, Duty Cycle, Delay for the
//	Block, Channel PWM
//
//*********************************************************************
//BOOL PCDSetD2APort(int Block,    		//Block 0
//int Channel,			  				//Channels 0-3
//int DigitalValue);		   			//0-65,535 
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	The PCD Driver successfuly set Block, Channel upon Returning
//	(TRUE)(1)(SUCCESS)
//
//	 The PCD Driver failed to set Block, Channelupon Returning
//	(FALSE)(0)(FAILURE)
//
//Description:
//	This function sets the digital value representation of the Analog 
//	out.
//
//*********************************************************************
//BOOL PCDSetDigitalConfig(int PortMask); //PortMask 0-65,535
//
//
//Pre:	PCD must be Open.
//		PCD must be Initialized
//Post:
//	Port Mask was set upon Returning (TRUE)(1)
//	(SUCCESS)
//
//	Port Mask was not set upon Returning (FALSE)(0)
//	(FAILURE)
//
//
//Description:
//
//	This function sets a port mask that controls the direction of the 
//	Digital ports. 1=Output 0=Input
//
//	Example: a PortMask value of 1 will set Block 0 Channel 0 to 
//		   Output and Block 0 Channel 1 to Input.
//
//*********************************************************************



//#define WIN_CE

#ifdef WIN_CE
EXPORT BOOL PCDInitialize(void);
EXPORT BOOL PCDOpen(void);
EXPORT BOOL PCDClose(void);
EXPORT BOOL PCDSetDigitalPort(int Block, int Channel,BYTE Value);
EXPORT BOOL PCDSendRaw(PUCHAR pSourceBytes, ULONG  NumberOfBytes);
EXPORT BOOL PCDSend2LCD(PUCHAR pSourceBytes, ULONG  NumberOfBytes);
EXPORT ULONG PCDGetKeypad(PUCHAR pTargetBuffer,ULONG BufferLength);
EXPORT WORD PCDGetA2DPort(int Block, int Channel);
EXPORT BYTE PCDGetDigitalPort(int Block, int Channel);
EXPORT WORD PCDGetCounter(int Block, int Channel);
EXPORT ULONG PCDGetRaw(PUCHAR pTargetBuffer,ULONG BufferLength);
EXPORT BOOL	PCDSendSerialPort(PUCHAR pSourceBytes, ULONG NumberOfBytes);
EXPORT BOOL PCDGetSerialPort(PUCHAR pTargetBuffer, ULONG BufferLength);
EXPORT BOOL PCDSetPWMPort(int Block, int Channel,int Frequency,int DutyCycle,int Delay);
EXPORT BOOL PCDSetD2APort(int Block, int Channel,int DigitalValue);
EXPORT BOOL	PCDSetDigitalConfig(int PortMask);
#endif

#ifdef LINUX
typedef unsigned char *PUCHAR;
typedef unsigned long ULONG;
typedef unsigned char BYTE;
typedef int	BOOL;

int PCDInitialize(void);
int PCDOpen(void);
int PCDClose(void);
int PCDSetDigitalPort(int Block, int Port,BYTE Value);
int PCDSendRaw(PUCHAR pSourceBytes, ULONG  NumberOfBytes);
int PCDSend2LCD(PUCHAR pSourceBytes, ULONG  NumberOfBytes);
int PCDGetKeypad(PUCHAR pTargetBuffer,ULONG BufferLength);
unsigned short PCDGetA2DPort(int Block, int Channel);
unsigned char PCDGetDigitalPort(int Block, int Port);
int PCDGetCounter(int Block, int Channel);
int PCDGetRaw(PUCHAR pTargetBuffer,ULONG BufferLength);
int	PCDSendSerialPort(PUCHAR pSourceBytes, ULONG NumberOfBytes);
int	PCDGetSerialPort(PUCHAR pTargetBuffer, ULONG BufferLength);
int	PCDSetPWMPort(int Channel,int Frequency,int DutyCycle,int Delay);
int	PCDSetD2APort(int Block, int Channel,int DigitalValue);
int	PCDSetDigitalConfig(int PortMask);
char getNB(void);

#define PortInitialize(arg) 0
#define PortClose() 0
#endif



