// PCDConsol.cpp : 
//

//#define WIN_CE


#ifndef LINUX
#define LINUX
#endif

#include <sys/types.h>
#include <asm/types.h>
#include "StdAfx.h"
#include <unistd.h>

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//																											   //
//							Load Menu Protoypes																   //
//																											   //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadSetDigitalPortsMenu();
void LoadGetDigitalPortsMenu();
void LoadGetKeypadMenu();
void LoadSend2LCDMenu();
void LoadGetA2DPortsMenu();
void LoadMainMenu();
void LoadPCDSendSerialPortMenu();
void LoadPCDGetSerialPortMenu();
void LoadPCDSetDigitalConfigMenu();
void LoadPCDSetD2AMenu();
void LoadPCDSetPWMMenu();



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//																											   //
//							Menu Protoypes																	   //
//																											   //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void MainMenu();
void SetDigitalPortsMenu();
void GetDigitalPortsMenu();
void GetA2DPortsMenu();
void GetKeypadMenu();
void Send2LCDMenu();
void PCDSetD2A();
void PCDSetPWMMenu();

unsigned char SetDigitalIN();
int SetD2AIN();



void PCDSendSerialPortMenu();
void PCDGetSerialPortMenu();
void PCDSetDigitalConfigMenu();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//																											   //
//									MAIN																	   //
//																											   //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifdef WIN_CE
void main ()
#endif
#ifdef LINUX
int main()
#endif
{ 

int bError;	

#ifdef WIN_CE

LPTSTR lpszPortName = TEXT("COM2:");
bError=!PortInitialize (lpszPortName);

#endif														//Main MENU

bError=!PCDInitialize();
bError=!PCDOpen();	
LoadMainMenu();
MainMenu();	 
bError=!PCDClose();

#ifndef WIN_CE
bError=!PortClose();
#endif

exit(1);


} //end Main

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	void MainMenu()
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LoadMainMenu()
{
char  buffer[1000];
int j=0;

j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tEMAC PCM-53E52 PCD TEST APPLICATION MAIN MENU\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> PCD Set Digital Ports\n\r");
j+=sprintf(buffer+j,"\t 2.> PCD Get Digital Ports\n\r");
j+=sprintf(buffer+j,"\t 3.> PCD Get A/D Ports\n\r");
j+=sprintf(buffer+j,"\t 4.> PCD Get Characters from Keypad\n\r");
j+=sprintf(buffer+j,"\t 5.> PCD Send Characters to LCD\n\r");
j+=sprintf(buffer+j,"\t 6.> PCD Send Characters to Serial\n\r");
j+=sprintf(buffer+j,"\t 7.> PCD Get Characters from Serial\n\r");
j+=sprintf(buffer+j,"\t 8.> PCD Set D/A Ports\n\r");
j+=sprintf(buffer+j,"\t 9.> PCD Set PWM Ports\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key to Quit\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);
}
void MainMenu()
{
unsigned char	keyin;

keyin = 0;
	
	while (keyin != 0x1B)// Not equal to the ESC key
	    {
		 keyin = GET();
		 

		
							 switch (keyin) {

									case 0x31:  //1 PCD Set Digital Port
											LoadSetDigitalPortsMenu();
											SetDigitalPortsMenu();
										   break;
						
									case  0x32: //2 PCD Get Digital Port
											LoadGetDigitalPortsMenu();
											GetDigitalPortsMenu();
										   break;
									case 0x33: //3 PCD Get A/D
											LoadGetA2DPortsMenu();
											GetA2DPortsMenu();
											break;
									case  0x34:  //4 PCD Get Keypad
											LoadGetKeypadMenu();
											GetKeypadMenu();
										  break;
									case 0x35: // 5 PCD Send to LCD
											LoadSend2LCDMenu();
											Send2LCDMenu();
											break;
									case 0x36: // 6 PCD Send to Serial
											LoadPCDSendSerialPortMenu();
											PCDSendSerialPortMenu();
											break;
									case 0x37: // 7 PCD Get Serial
											LoadPCDGetSerialPortMenu();
											PCDGetSerialPortMenu();
											break;
									case 0x38: // 8 PCD Set D/A
											LoadPCDSetD2AMenu();
											PCDSetD2A();
											break;
									case 0x39: // 9 PCD Set PWM
											LoadPCDSetPWMMenu();
											PCDSetPWMMenu();
											break;

									
									};
	}



}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	SetDigitalPortsMenu()
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadSetDigitalPortsMenu()
{
char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tSET DIGITAL PORT MENU\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> PCD Set Digital Block 0 Port 1\n\r");
j+=sprintf(buffer+j,"\t 2.> PCD Set Digital Block 0 Port 2\n\r");
j+=sprintf(buffer+j,"\t 3.> PCD Set Digital Configuration\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);

}

void SetDigitalPortsMenu()
{

int bError;
unsigned char	keyin;
unsigned char	SetDigital;

keyin = 0;
	
while (keyin != 0x1B)// Not equal to the ESC key
  {
    keyin = GET();
    
    switch (keyin) {
      
						case 0x31:		//1   PCD Set Digital Block 0 Channel 0
      
      
						  SetDigital=SetDigitalIN();
						  bError=!PCDSetDigitalPort(0,1,SetDigital);
						  printf("%x",SetDigital);
						  LoadSetDigitalPortsMenu();
						  break;
							   
						case  0x32:		//2   PCD Set Digital Block 0 Channel 1
						  SetDigital=SetDigitalIN();
						  bError=!PCDSetDigitalPort(0,2,SetDigital);
						  LoadSetDigitalPortsMenu();
						  break;

			case 0x33:		//3	  PCD Set Digital Configuration
							LoadPCDSetDigitalConfigMenu();
							PCDSetDigitalConfigMenu();
							break;
    };
LoadSetDigitalPortsMenu();
  }


LoadMainMenu();//ESC key

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	SetDigitalIN()
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
unsigned char SetDigitalIN()
{

char  buffer[1000];
int j=0;
//int i=0;


char	DigitalIN[10];
unsigned char	keyin;
unsigned char	SetDigital=0;


keyin = 0;

j = sprintf(buffer,"\tPress the ESC Key Exit\n\r");
j += sprintf(buffer+j,"\tEnter an 8 bit value and press the Enter Key to Set Port\n\r");
PRINT(buffer,j);




fgets(DigitalIN,sizeof(DigitalIN),stdin);				       
SetDigital = (char)strtoul(DigitalIN,NULL,0);

return SetDigital;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Load Set Digital Ports Configuration Menu()
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LoadPCDSetDigitalConfigMenu()
{

char  buffer[1000];
int j=0;

j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\t Enter a 16 bit digital mask for Digital ports 1&2 \n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Set Digital Ports Configuration Menu()
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
void PCDSetDigitalConfigMenu()
{
char  buffer[1000];
int j=0;
//int i=0;
int bError;

char	DigitalIN[10];
unsigned char	keyin;
//unsigned char	SetDigital=0;
int PortMask=0;

keyin = 0;
j = sprintf(buffer,"\t\n\r");
j += sprintf(buffer+j,"\tPress the Enter Key to Set Digital Port Configuraion \n\r");
PRINT(buffer,j);

/*
i=0;
while (keyin != 0x1B && keyin!= 0x0D)
  {
    keyin = 0;
    keyin = GET();
    
    j=0;
    
    if(((keyin > 0x2F && keyin < 0x3A) || (keyin >0x40 && keyin < 0x47)) && (i<5))
      {		
	j = sprintf(buffer+j,"%c", keyin );		
	PRINT(buffer,j);
	SetDigital=keyin;
	i+=sprintf(DigitalIN+i,"%c", SetDigital );		
	sprintf(DigitalIN+(i+1),"%c", '\0' );
	
      }	
    
  }
  */
fgets(DigitalIN,sizeof(DigitalIN),stdin);

PortMask=strtoul(DigitalIN,NULL,0);
bError=!PCDSetDigitalConfig(PortMask); 
LoadPCDSetDigitalConfigMenu();											
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	GetDigitalPortsMenu()
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadGetDigitalPortsMenu()
{
char  buffer[1000];
int j=0;

j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tGet Digital Port Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> PCD Get Digital Block 0 Port 1\n\r");
j+=sprintf(buffer+j,"\t 2.> PCD Get Digital Block 0 Port 2\n\r");
j+=sprintf(buffer+j,"\t 3.> PCD Get All Digital Block 0 Channels\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);

}



void GetDigitalPortsMenu()
{
char  buffer[1000];
int j=0;
unsigned char	keyin;
unsigned char	DigitalPort;
keyin = 0;
	
while (keyin != 0x1B)// Not equal to the ESC key
	    {
	      keyin = GET();
	      
	      
	      
	      switch (keyin) {
		
	      case 0x31:	
		j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
		PRINT(buffer,j);
		while (keyin != 0x1B)
		  {
		    keyin = GET();
		    DigitalPort=PCDGetDigitalPort(0,1);
		    j = sprintf(buffer,"\tPCDGetDigitalPort(Block 0, Port 1):%03x\r", DigitalPort );
		    PRINT(buffer,j);
		    
												}
		keyin = 0;
		LoadGetDigitalPortsMenu();
		break;
						
	      case  0x32:		
		j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
		PRINT(buffer,j);
		
		while (keyin != 0x1B)
		  {
		    keyin = GET();
		    
		    DigitalPort=PCDGetDigitalPort(0,2);
		    j = sprintf(buffer,"\tPCDGetDigitalPort(Block 0,Port 2):%03x\r", DigitalPort );
		    PRINT(buffer,j);
		    
		  }
		keyin = 0;
		LoadGetDigitalPortsMenu();
		break;
	      case 0x34:		
		
		break;
	      case  0x35:		
		
		break;
	      case 0x33:		
		
		j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
		j += sprintf(buffer+j,"\t\n\r 0   1\n\r");
		
		PRINT(buffer,j);	
		while (keyin != 0x1B)
		  {
		    keyin = GET();
		    
		    DigitalPort=PCDGetDigitalPort(0,1);
		    j = sprintf(buffer,"\r %03x ", DigitalPort);
		    DigitalPort=PCDGetDigitalPort(0,2);
		    j+=sprintf(buffer+j,"%03x ", DigitalPort );
		    PRINT(buffer,j);
		    
		  }
		keyin = 0;
		LoadGetDigitalPortsMenu();
		break;
		
	      };
	    }


LoadMainMenu();//ESC key

}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	LoadPCDGetA2DPortMenu
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////	 
void LoadPCDSetD2AMenu()
{
char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tSet D/A Port Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> PCD Set D/A Block 0 Channel 0 \n\r");
j+=sprintf(buffer+j,"\t 2.> PCD Set D/A Block 0 Channel 1 \n\r");
j+=sprintf(buffer+j,"\t 3.> PCD Set D/A Block 0 Channel 2 \n\r");
j+=sprintf(buffer+j,"\t 4.> PCD Set D/A Block 0 Channel 3 \n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);

}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	PCDSetD2A
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

void PCDSetD2A()
{

int bError;

unsigned char	keyin;
int				DigitalValue;

keyin = 0;
	
while (keyin != 0x1B)// Not equal to the ESC key
  {
    keyin = GET();
    
    switch (keyin) {
      
    case 0x31:		//1   PCDSetD2A Channel 0
      DigitalValue=SetD2AIN();
      bError=!PCDSetD2APort(0, 0,DigitalValue);
      LoadPCDSetD2AMenu();
      break;
		   
    case  0x32:		//2   PCDSetD2A Channel 1  
      DigitalValue=SetD2AIN();
      bError=!PCDSetD2APort(0, 1,DigitalValue);
      LoadPCDSetD2AMenu();
      break;
    case 0x33:		//3   PCDSetD2A Channel 2
      
      DigitalValue=SetD2AIN();
      bError=!PCDSetD2APort(0, 2,DigitalValue);
      LoadPCDSetD2AMenu();
      break;
    case  0x34:	
					//4   PCDSetD2A Channel 3
      DigitalValue=SetD2AIN();
      bError=!PCDSetD2APort(0, 3,DigitalValue);
      LoadPCDSetD2AMenu();
      break;
    };
  }

LoadMainMenu();//ESC key

}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	int SetD2AIN()
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
int SetD2AIN()
{

char  buffer[1000];
int j=0;
int i=0;


char	DigitalIN[6];
unsigned char	keyin;
int DigitalValue=0;

keyin = 0;

j = sprintf(buffer,"\t\n\r");
j += sprintf(buffer+j,"\tPress the Enter Key to Set Port\n\r");
PRINT(buffer,j);

i=0;

fgets(DigitalIN,sizeof(DigitalIN),stdin);


/*
while (keyin != 0x1B && keyin!= 0x0D)
  {
    keyin = 0;
    keyin = GET();
    j=0;
    
    if(((keyin > 0x2F && keyin < 0x3A) || (keyin >0x40 && keyin < 0x47)) && (i<5))
      {		
	j = sprintf(buffer+j,"%c", keyin );		
	PRINT(buffer,j);
	i+=sprintf(DigitalIN+i,"%c", keyin );		
	sprintf(DigitalIN+(i+1),"%c", '\0' );
	
      }	
  }
					
DigitalValue= atoi(DigitalIN);
*/

DigitalValue=strtoul(DigitalIN,NULL,0);

return DigitalValue;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	PCDGetA2DPort
//
// 
//											
//													
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LoadGetA2DPortsMenu()
{

char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tGet A/D Port Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> PCD Get A/D Block 0/Channels \n\r");
j+=sprintf(buffer+j,"\t 2.> PCD Get A/D Block 1/Channels \n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);
}

void GetA2DPortsMenu()
{
char  buffer[1000];
int j=0;
unsigned char	keyin;
unsigned short	A2DPort;
	
	
keyin = 0;

while (keyin != 0x1B)// Not equal to the ESC key
  {
    keyin = GET();
    
    
    
    switch (keyin) {
      
    case 0x31:  //1 
        j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
      j += sprintf(buffer+j,"\t\n\r 0   1    2    3    4    5    6    7    8    9    10   11   12   13   14   15\n\r");
      PRINT(buffer,j);	
      while (keyin != 0x1B)
	{
	  keyin = GET();
	  
	  A2DPort=PCDGetA2DPort(0,0);
	  j = sprintf(buffer,"\r%03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,1);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,2);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,3);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,4);
	  j+= sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,5);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,6);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,7);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,8);
	  j+= sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,9);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,10);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,11);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,12);
	  j+= sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,13);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,14);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(0,15);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  PRINT(buffer,j);
	  
	}
      keyin = 0;
     LoadGetA2DPortsMenu();
      break;
      
    case  0x32: //2 
       j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
     j += sprintf(buffer+j,"\t\n\r 0   1    2    3    4    5    6    7\n\r");
      PRINT(buffer,j);	
      while (keyin != 0x1B)
	{
	  keyin = GET();
	  
	  A2DPort=PCDGetA2DPort(1,0);
	  j = sprintf(buffer,"\r%03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,1);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,2);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,3);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,4);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,5);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,6);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  A2DPort=PCDGetA2DPort(1,7);
	  j+=sprintf(buffer+j," %03x ", A2DPort );
	  PRINT(buffer,j);
	}
      keyin = 0;
      LoadGetA2DPortsMenu();
      break;
    case 0x33: //3 
      break;
    case  0x34://4 
      break;
    case 0x35: //5
      break;
      
    };
  }

LoadMainMenu();//ESC key
}




/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	PCDGetKeypad
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////


void LoadGetKeypadMenu()
{

char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tGet Keypad Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> Get Keypad\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);

}

void GetKeypadMenu()
{
char  buffer[1000];
int j=0;	
unsigned char Keypad;
unsigned char	keyin=0;
int bError;




while (keyin != 0x1B)// Not equal to the ESC key
  {
    keyin = GET();
    
    
    
    switch (keyin) {
      
    case 0x31:	
      j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
      PRINT(buffer,j);
      while (keyin != 0x1B)
	{
	  keyin = getNB();
	  //keyin = GET();
	  Keypad=0;
	  bError=PCDGetKeypad(&Keypad,1);
	  //Keypad[bError]=0;
	  //j = sprintf(buffer,"%c", Keypad );
	  //printf("%c",Keypad);
	  write(1,&Keypad,1);
	  //PRINT(buffer,j);			
	}
      keyin = 0;
      LoadGetKeypadMenu();
      break;
    };
    
  }

LoadMainMenu();

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	 PCDSend2LCD
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////


void LoadSend2LCDMenu()
{
char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tSend to LCD Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> Send to LCD\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);
}


void Send2LCDMenu()
{
char  buffer[1000];
char buffer2[100];
int j=0;	
unsigned char	keyin=0;
int bError;
const char *creturn = "\r";


while (keyin != 0x1B)// Not equal to the ESC key
  {
   
    keyin=0;
    keyin = GET();
    
    
    j = sprintf(buffer,"\tPress the ESC Key to Stop Sending Characters\n\r");
    PRINT(buffer,j);

    switch (keyin) {
      
    case 0x31:	
     
     
      
     
      fgets(buffer2,sizeof(buffer2),stdin);	
      bError=PCDSend2LCD((unsigned char *)buffer2,strlen(buffer2));
      printf("PCDSend2LCD returned %u\n",bError);    
      PCDSend2LCD((unsigned char *)creturn,strlen(creturn));
      keyin = 0;
      LoadSend2LCDMenu();
      break;
      };
    
  }

LoadMainMenu();
}



/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	 PCDSendSerialPort
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////


void LoadPCDSendSerialPortMenu()
{
char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tSend to Serial Port Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> Send to Serial Port\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);
}


void PCDSendSerialPortMenu()
{
char  buffer[1000];
char buffer2[100];
int j=0;	
unsigned char	keyin=0;
int bError;



while (keyin != 0x1B)// Not equal to the ESC key
  {
   
    keyin=0;
    keyin = GET();
    
    
    j = sprintf(buffer,"\tPress the ESC Key to Stop Sending Characters\n\r");
    PRINT(buffer,j);

    switch (keyin) {
      
    case 0x31:	
     
     
      
     
      fgets(buffer2,sizeof(buffer2),stdin);	
      bError=PCDSendSerialPort((unsigned char *)buffer2,strlen(buffer2));
      printf("PCDSendSerial returned %u\n",bError);
      keyin = 0;
      LoadPCDSendSerialPortMenu();
      break;
      };
    
  }

LoadMainMenu();

}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	PCDGetSerial
//
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////


void LoadPCDGetSerialPortMenu()
{

char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tGet Serial Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> Get Serial\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);

}

void PCDGetSerialPortMenu()
{
char  buffer[1000];
int j=0;	
unsigned char Serial=0;
unsigned char	keyin=0;
int bError;



while (keyin != 0x1B)// Not equal to the ESC key
  {
    keyin = GET();
    
    switch (keyin) {
      
    case 0x31:	
      j = sprintf(buffer,"\tPress the ESC Key to Stop Readings\n\r");
      PRINT(buffer,j);
      while (keyin != 0x1B)
	{
	  //keyin = GET();
	  keyin = getNB();
	  Serial=0;
	  bError=!PCDGetSerialPort(&Serial,1);
	  write(1,&Serial,1);
	  //j = sprintf(buffer,"%c", Serial );
	  //PRINT(buffer,j);		
	}
      keyin = 0;
      Serial=0;
      LoadPCDGetSerialPortMenu();
      break;
    };    
  }
LoadMainMenu();
}



void LoadPCDSetPWMMenu()
{
char  buffer[1000];
int j=0;
j= sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
j+=sprintf(buffer+j,"\r\tSet PWM Menu\n\r");
j+=sprintf(buffer+j,"\n\r");
j+=sprintf(buffer+j,"\t 1.> Set PWM Channel\n\r");
j+=sprintf(buffer+j,"\t 2.> Set PWM Frequency\n\r");
j+=sprintf(buffer+j,"\t 3.> Set PWM DutyCycle\n\r");
j+=sprintf(buffer+j,"\t 4.> Set PWM Delay\n\r");
j+=sprintf(buffer+j,"\t 5.> Send Data to PCD\n\r");
j+=sprintf(buffer+j,"\t Press ESC Key for Main Menu\n\r");
j+=sprintf(buffer+j,"\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
PRINT(buffer,j);
}

void PCDSetPWMMenu()
{

char  buffer[1000];
int j=0;
int i=0;	
	
char	DataIN[6];

int Block=0;
int Channel=0;
int Frequency=0;
int DutyCycle=0;
int Delay=0;
int bError;

char keyin[5]={0,0,0,0,0};


while (keyin[0] != 0x1B)// Not equal to the ESC key
  {
   
    fgets(keyin,sizeof(keyin),stdin);			
						j = sprintf(buffer,"\tPWM BLOCK:%i", Block );
						j += sprintf(buffer+j,"\t  PWM CHANNEL:%i", Channel );
						j += sprintf(buffer+j,"\t  PWM FREQUECY:%i", Frequency );
						j += sprintf(buffer+j,"\t  PWM DUTY CYCLE:%i", DutyCycle );
						j += sprintf(buffer+j,"\t  PWM DELAY:%i\r", Delay );
						PRINT(buffer,j);
	
	switch (keyin[0]) {
      
 case  0x31: //2 Channel
										j = sprintf(buffer,"\tEnter PWM Channel:%i\r\n", Channel );
										PRINT(buffer,j);	
										i=0;
										keyin[0] = 0;								  
										
fgets(DataIN,sizeof(DataIN),stdin);
Channel=(int)strtoul(DataIN,NULL,0);
										break;
									case 0x32: //3 Frequency
										j = sprintf(buffer,"\tEnter PWM Frequency:%i\r\n", Frequency );
										PRINT(buffer,j);
										i=0;
 keyin[0] = 0;										
 fgets(DataIN,sizeof(DataIN),stdin);
										Frequency=(int)strtoul(DataIN,NULL,0);
										LoadPCDSetPWMMenu();
										break;
									case  0x33:  //4 Duty Cycle
										j = sprintf(buffer,"\tEnter PWM Duty Cycle:%i\r\n", DutyCycle );
										PRINT(buffer,j);	
										i=0;
		keyin[0] = 0;										
fgets(DataIN,sizeof(DataIN),stdin);										
DutyCycle=(int)strtoul(DataIN,NULL,0);
										LoadPCDSetPWMMenu();
										break;
									case 0x34: // 5 Delay
										j = sprintf(buffer,"\tEnter PWM Delay:%i\r\n", Delay );
										PRINT(buffer,j);	
										i=0;
		keyin[0] = 0;										
										
										fgets(DataIN,sizeof(DataIN),stdin);
										Delay=(int)strtoul(DataIN,NULL,0);
										LoadPCDSetPWMMenu();
										break;
									case 0x35: // 6 Send PWM Data to PCD
										bError=!PCDSetPWMPort(Channel,Frequency,DutyCycle,Delay);
									       
										j = sprintf(buffer,"\t  PWM CHANNEL:%i", Channel );
										j += sprintf(buffer+j,"\t  PWM FREQUECY:%i", Frequency );
										j += sprintf(buffer+j,"\t  PWM DUTY CYCLE:%i", DutyCycle );
										j += sprintf(buffer+j,"\t  PWM DELAY:%i\r", Delay );
										PRINT(buffer,j);
									        
 break;
										
									
	};    

LoadPCDSetPWMMenu();  
  }



				
LoadMainMenu();
}









