#ifdef __cplusplus
#define EXPORT extern "C" __declspec (dllexport)
#else
#define EXPORT __declspec (dllexport)
#endif

#ifdef LINUX
typedef unsigned char *PUCHAR;
typedef unsigned long ULONG;
typedef unsigned char BYTE;
typedef __u16 WORD;
typedef int	BOOL;
#define PortInitialize(arg) 0
#define PortClose() 0
#endif
//C FUNCTION DEFINITIONS

BOOL PCDInitialize(void);                       //passed parameters (0
/*********************************************************************



Pre: The PCD Driver Driver must be Closed

Post:
        The PCD Driver will be initialized upon Returning (TRUE)(1)
        (SUCCESS)

        The PCD Driver will not be initialized upon Returning (FALSE)(0)
        (FAILURE)

Description:
        A Call to this function will initialize the PCD Device Driver


*********************************************************************/


BOOL PCDOpen(void);  //passed parameters (0)
/*********************************************************************

                             

Pre:    The Device must be Closed.
        The Device must be Initialized

Post:
        The PCD Driver will be open upon Returning (TRUE)(1)
        (SUCCESS)

        The PCD Driver will not be open upon Returning (FALSE)(0)
        (FAILURE)


Description:

        A successful return from this function will result in the
        open state of the PCD and make it available for Read/Write
        operations.
*********************************************************************/


BOOL PCDClose(void);                            //passed parameters (0)
/*********************************************************************




Pre:    PCD must be Open.
        PCD must be Initialized

Post:
        The PCD Driver will be closed upon Returning (TRUE)(1)
        (SUCCESS)

        The PCD Driver will not be closed upon Returning (FALSE)(0)
        (FAILURE)

Description:
                A successful return from this function will result in the
                closed state of the PCD and free driver allocated memory.


*********************************************************************/

BOOL PCDGetKeypad(PUCHAR pTargetBuffer,ULONG BufferLength); 
/*********************************************************************
       

Pre:    PCD must be Open.
        PCD must be Initialized

Post:
        Returns a unsigned long number of bytes that was put into
        pTargetBuffer

Description
        This function gets a user-defined number of data bytes from
        the keypad and puts the data into the pTargetBuffer.
*********************************************************************/




WORD PCDGetA2DPort(int Block,                   //Block 0 selects 10 bit A/D.
//Block 1 selects optional 12 bit A/D 
int Channel);                                           //Block 0 channel range is 0 to 15
                                                        //Block 1 channel range is 0 to 7

/*********************************************************************
Pre:    PCD must be Open.
        PCD must be Initialized
Post:
        PCD Returns a 16 bit unsigned short integer representing
        the user defined Block and Channel.


Description:
                The PCD Driver returns a 16 bit unsigned short integer
                representing the user selected Block and Channel.

*********************************************************************/



BOOL PCDSetD2APort(int Block,                   //Block 0
int Channel,                                    //Channels 0-3
int DigitalValue);                              //0-0x3FF
/*********************************************************************


Pre:    PCD must be Open.
        PCD must be Initialized
Post:
        The PCD Driver successfuly set Block, Channel upon Returning
        (TRUE)(1)(SUCCESS)

         The PCD Driver failed to set Block, Channelupon Returning
        (FALSE)(0)(FAILURE)

Description:
        This function sets the analog output of the selected DAC channel.
*********************************************************************/



BOOL PCDSetDigitalConfig(int PortMask);         //PortMask 0-65,535
/*********************************************************************

Pre:    PCD must be Open.
        PCD must be Initialized
Post:
        Port Mask was set upon Returning (TRUE)(1)
        (SUCCESS)

        Port Mask was not set upon Returning (FALSE)(0)
        (FAILURE)


Description:
Bits 0 to 15 of PortMask correspond directly to digital lines PX8 to PX23,
respectively.A bit set to 1 configures the respective digital line as an
output and a bit set to 0 makes it an input.

*********************************************************************/


BYTE PCDGetDigitalPort(int Block,               //Block 0
int Port);                                       //Ports 1, 2
/*********************************************************************

Pre:    PCD must be Open.
        PCD must be Initialized.
        PCD Digital Port Direction must be Set
Post:
        The PCD Driver Returns Byte for Block and Port

Description:
        This function currently supports one Block and two Ports.
        A modification will be made to output pins only.
        Port 0 Currently Not Supported

*********************************************************************/


BOOL PCDSetDigitalPort(int Block,               //Block 0
int Port,                                       //Ports 1, 2
BYTE Value);                                    //Value 8-bit
/*********************************************************************

Pre:    PCD must be Open.
        PCD must be Initialized.
Post:
        The PCD Driver successfully loaded Block, Port, Value upon
        Returning (TRUE),(1),(SUCCESS).

        The PCD Driver failed to load Block, Port, Value upon
        Returning (FALSE),(0),(FAILURE).

Description:
         This function currently supports one Block and two Ports.
         A modification will be made to output pins only.
         Port 0 Currently Not Supported
******************************************************************/


BOOL PCDSendSerialPort(PUCHAR pSourceBytes,     //(unsigned char *) to
                                                //array of characters or
                                                //unsigned char string
                                                //name

ULONG NumberOfBytes);                           //unsigned long number of
/*********************************************************************
                                                        //bytes to send to serial
                                                        //port


Pre:    PCD must be Open.
        PCD must be Initialized

Post:
        The PCD Driver successfully sent user defined number of bytes and
        load them from the pSourceBytes Buffer upon Returning
        (TRUE)(1)(SUCCESS)
        The PCD Driver failed to send user defined number of bytes and
        load them from the pSourceBytes Buffer upon Returning
        (FALSE)(0)(FAILURE)

Description:
        This function gets a user-defined number of data bytes from
        the PCD serial port and puts the data into the pTargetBuffer.




*********************************************************************/


BOOL PCDGetSerialPort(PUCHAR pTargetBuffer,     //(unsigned char *) to
                                                        //array of characters
                                                        //or unsigned char
                                                        //string name

ULONG BufferLength);                                    //unsigned long number of
                                                        //bytes to receive from
                                                        //serial port

/*********************************************************************

Pre:    PCD must be Open.
        PCD must be Initialized

Post:
        The PCD Driver successfully received user defined number of bytes and
        loaded them into the PTargetBuffer upon Returning
        (TRUE)(1)(SUCCESS)

        The PCD Driver failed to receive user defined number of bytes and
        load them into the PTargetBuffer upon Returning
        (FALSE)(0)(FAILURE)


Description:
        This function gets a user-defined number of data bytes from
        the PCD serial port and puts the data into the
        pTargetBuffer.

*********************************************************************/


BOOL PCDSetPWMPort(int Channel, //Channels      0-15


int Frequency,                          //Frequency     0-100 (kHz)
int DutyCycle,                          //DutyCycle     0-100 (%)
int Delay);                             //Delay         0-65,535 (Milliseconds)


/*********************************************************************
Pre:    PCD must be Open.
        PCD must be Initialized

Post:
         upon Returning (TRUE)(1)
        (SUCCESS)

         upon Returning (FALSE)(0)
        (FAILURE)

Description:
        This function sets the Frequency, Duty Cycle, Delay for the
        Channel PWM
*********************************************************************/



char getNB(void);
/********************************************************************
non blocking getchar function.
*********************************************************************/


BOOL PCDSend2LCD(PUCHAR pSourceBytes, ULONG  NumberOfBytes);
/********************************************************************
Pre:    PCD must be Open.
        PCD must be Initialized

Post:
         upon Returning (TRUE)(1)
        (SUCCESS)

         upon Returning (FALSE)(0)
        (FAILURE)

Description:
        This function sends a formatting string to the LCD of the
pcd-e12. it supports the following special characters

'\b' backspace 1
'\a' advance 1
'\n' linefeed
'\r' carriage return
'\v' end of line
'\t' tab

*********************************************************************/



