#ifndef LINUX
#define LINUX
#endif
#include <unistd.h>
#include <sys/types.h>
#include <asm/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "StdAfx.h"
#include <sys/time.h>


#define SSIDEV "/dev/ssi"
#define ATDEV  "/dev/atd0"
#define ATDEV2 "/dev/atd4"
#define DIGDEV "/dev/dig0"
#define CNTDEV "/dev/count"
#define KEYDEV "/dev/key" 
#define COPDEV "/dev/cop"
#define SER0DEV "/dev/PCD232"
#define SER1DEV "/dev/PCE422"


static int SSIfd,COPfd,Keyfd,Serfd; /*global fds for SSI,COP,and Keypad*/

int PCDInitialize(void)
{
printf("PCD Initialize\n");
return 0;
}


int PCDOpen(void)
{
printf("PCDOpen\n");/*open all of the always rx type ports*/
SSIfd = open(SSIDEV,O_RDWR);
COPfd = open(COPDEV,O_RDWR);
Keyfd = open(KEYDEV,O_RDWR);
Serfd = open(SER0DEV,O_RDWR);
return 0;
}


int PCDClose(void)
{
printf("PCDClose\n");
close(Serfd);
close(Keyfd);
close(COPfd);
close(SSIfd);
return 0;
}





int PCDSetDigitalPort(int Block, int Port,BYTE Value)
{
int fd,err;
char portname[20];
int channel = Port;

sprintf(portname,"/dev/dig%u",channel);

printf("PCDSetDigitalPort, opening %s\n",portname);

if((fd=open(portname,O_RDWR))<=0)
  {
printf("couldn't open Digital port\n");
return 0;
  }

err = write(fd,&Value,1);

close(fd);
return 0;
}


int PCDSendRaw(PUCHAR pSourceBytes, ULONG  NumberOfBytes)
{
write(SSIfd,pSourceBytes,NumberOfBytes);
return 0;
}



int PCDSend2LCD(PUCHAR pSourceBytes, ULONG  NumberOfBytes)
{
int retval;
int fd;
  //printf("PCDSend2LCD not yet supported\n");


if((fd=open("/dev/LCD",O_RDWR))<=0)
  {
printf("couldn't open LCD port\n");
return 0;
  }
retval = write(fd,pSourceBytes,NumberOfBytes);
close(fd);

return(retval);

return 0;
}



int PCDGetKeypad(PUCHAR pTargetBuffer,ULONG BufferLength)
{
//int fd; 
  //printf("PCDGetKeypad\n");

//if((fd=open(KEYDEV,O_RDWR))<=0)
//  {//keypad left open in the application so data can be rxd anytime
//printf("couldn't open Keypad port\n");
//return 0;
//  }

read(Keyfd,pTargetBuffer,BufferLength);
//close(fd);
return 0;
}




unsigned short PCDGetA2DPort(int Block, int Channel)
{
int fd; 
unsigned short data;
char portname[20];
int channel = Channel +(Block*16);

sprintf(portname,"/dev/atd%u",channel);
//printf("PCDGetA2DPort, opening %s\n",portname);

if((fd=open(portname,O_RDWR))<=0)
  {
printf("couldn't open atd port\n");
return 0;
  }

while(!read(fd,&data,2));
//read(fd,&data,2);

close(fd);

return data;
}


unsigned char PCDGetDigitalPort(int Block, int Port)
{
int fd; 
unsigned char data;
int channel = Port;
char portname[20];

sprintf(portname,"/dev/dig%u",channel);

//printf("PCDGetDigitalPort, opening %s\n",portname);

if((fd=open(portname,O_RDWR))<=0)
  {
printf("couldn't open Digital port\n");
return 0;
  }

read(fd,&data,1);
close(fd);
return data;
}

int PCDGetCounter(int Block, int Channel)
{
printf("PCDGetCounter not supported\n");
return 0;
}

int PCDGetRaw(PUCHAR pTargetBuffer,ULONG BufferLength)
{
read(SSIfd,pTargetBuffer,BufferLength);
return 0;
}


int PCDSendSerialPort(PUCHAR pSourceBytes, ULONG NumberOfBytes){
return(write(Serfd,pSourceBytes,NumberOfBytes));
}


int PCDGetSerialPort(PUCHAR pTargetBuffer, ULONG BufferLength){
return(read(Serfd,pTargetBuffer,BufferLength));
}


int PCDSetPWMPort(int Channel,int Frequency,int DutyCycle,int Delay)
{
char portname[20];
int port;
int fd;

struct{
__u16 pwm;
__u16 frequency;
__u16 duty;
__u16 delay;
}config;



config.pwm = Channel;
config.frequency = Frequency;
config.duty = DutyCycle;
config.delay = Delay;
port = config.pwm/8;


if(config.pwm>15)
{
  printf("no such PWM\n");
  return -1;
}

if(config.pwm>7)
config.pwm-=8;

sprintf(portname,"/dev/dig%u",port);

printf("PCDGetDigitalPort, opening %s\n",portname);

if((fd=open(portname,O_RDWR))<=0)
  {
printf("couldn't open Digital port\n");
return 0;
  }

ioctl(fd,1,&config);//pass configuration structure to the correct port

close(fd);

return 0;
}


int PCDSetD2APort(int Block, int Channel,int DigitalValue)
{
int fd,err;
char portname[20];

sprintf(portname,"/dev/daq%u",Channel);

//printf("PCDSetD2APort, opening %s\n",portname);

if((fd=open(portname,O_RDWR))<=0)
  {
printf("couldn't open D2A port\n");
return 0;
  }


//printf("sending %x\n",DigitalValue);

err = write(fd,&DigitalValue,2);

if(err!=2)
printf("couldn't write to D2A device\n");

close(fd);
return 0;
}


int PCDSetDigitalConfig(int PortMask)
{
int fd0,fd1;

if((fd0=open("/dev/dig1",O_RDWR))<=0)
  {
printf("couldn't open Digital port 1\n");
return 0;
  }

if((fd1=open("/dev/dig2",O_RDWR))<=0)
  {
printf("couldn't open Digital port 0\n");
return 0;
  }

ioctl(fd0,0,(__u8)(PortMask&0xFF));//pass mask to the correct port
ioctl(fd1,0,(__u8)(PortMask>>8));//pass mask to the correct port


close(fd0);
close(fd1);


return 0;
}

char gech(void)
{
char keyin[5]={0,0,0,0,0};
fgets(keyin,sizeof(keyin),stdin);	

return(keyin[0]);
}

char getNB(void)
{
char data=0;
fd_set rfds;
struct timeval tv;
int retval;

           /* Watch stdin (fd 0) to see when it has input. */
FD_ZERO(&rfds);
FD_SET(0, &rfds);
           
tv.tv_sec = 0;
tv.tv_usec = 50;

retval = select(1, &rfds, NULL, NULL, &tv);
           /* Don't rely on the value of tv now! */

if (retval)
read(0,&data,1);


 
return data;
      
}


