/*
ODedit

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

10/14/02 

Description:
A small C program using the canopen libraries 
to read/write the OL of CANOPEN device

ex:
using an AMC device object;

ODedit r can0 01 0x1000
>20192

ODedit w can0 01 0x100B 4
>data written
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <asm/types.h>
#include <unistd.h>
#include <curses.h>

#include "Can.h"
#include "CanOpenMatic.h"
#include "CanOpener.h"
#include "Can4Open.h"


void printpacket(Message *m, int state);




int busfd;

int main()
{
char rw;
int index = 0;
__u16 data = 0;
char z;
int nodeID;
char can_device[40];
extern logfunc rxloggingfunc,txloggingfunc;
extern int wait;

wait = 1;
rxloggingfunc = printpacket;
txloggingfunc = printpacket;

   if((busfd = f_can_open("/dev/can1"))<=0)
     {
       printf("couldn't open can1");
       return 0;
     }
    
    for (z=1; z<=100; z++)
    {
        index = 0x0600 + z;
	WriteDictionaryEntry(0, 0x01, 0x6041, 0, 0x02, &index);
	WriteDictionaryEntry(0, 0x01, 0x6041, 0, 0x02, &index);
    }
    
    printf("data written\n");
    f_can_close(busfd);
    return(0);
}

void printpacket(Message *m, int state)
{
  int i;
  extern proceed_info proceed_infos[];
  if(state>=0){
    int fc = GET_FUNCTION_CODE((*m));
    int ID = GET_NODE_ID((*m));
    printf("%s%-6.6s %2.2x %s",
	      state == STATE_Tx ? ">" : "<",
	      proceed_infos[fc].name,
	      ID,
	      m->rtr ? "Yes" : "No ");
    for ( i = 0; i < m->len;i++){
      printf("%2.2x ",m->data[i]);
    }
      printf("\n");
  } else {
    printf("Read Error (%d)",state);
  }
  
  
}









