/*
ODedit

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

10/14/02 

Description:
A small C program using the canopen libraries 
to read/write the OL of CANOPEN device

ex:
using an AMC device object;

ODedit r can0 01 0x1000
>20192

ODedit w can0 01 0x100B 4
>data written
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <asm/types.h>
#include <unistd.h>
#include <curses.h>

#include "Can.h"
#include "CanOpenMatic.h"
#include "CanOpener.h"
#include "Can4Open.h"


void printpacket(Message *m, int state);


static int help(void)
{
const char *help_table = "********************************
*ODedit                        *
*10/14/02 Nathan Z. Gustavson  *
*Emac.inc                      * 
*                              *   
*usage:                        *   
*ODedit w/r bus ID index (data)*   
********************************\n";


printf("%s",help_table);


return 0;
}


int busfd;

int main(int argc,char **argv)
{
char rw;
__u32 index = 0;
__u32 data = 0;
int nodeID;
char can_device[40];
//extern logfunc rxloggingfunc,txloggingfunc;
//extern int wait;

//wait = 1;
//rxloggingfunc = printpacket;
//txloggingfunc = printpacket;

switch(argc)
  {
  case 5:
  rw = *argv[1];
  
    if(rw!='r')
     {
       help();
       return 0;
     }
   sprintf(can_device,"/dev/%s",argv[2]);
   if((busfd = f_can_open(can_device))<=0)
     {
       printf("couldn't open %s\n",can_device);
       return 0;
     }
   index = (__u32)strtoul(argv[4],NULL,0);
   nodeID = (int)strtoul(argv[3],NULL,0);
   
   //printf("reading from %s id=%x index = %x subindex 0\n",can_device,nodeID,index);
   ReadDictionaryEntry(0, nodeID, index, 0, (char *)&data);
   printf("%lx\n",(unsigned long)data);
   f_can_close(busfd);
   break;
   
  case 6:
  rw = *argv[1];
    if(rw!='w')
      {
	help();
	return 0;
      }
    sprintf(can_device,"/dev/%s",argv[2]);
    if((busfd = f_can_open(can_device))<=0)
      {
	printf("couldn't open %s\n",can_device);
	return 0;
      }
    nodeID = (int)strtoul(argv[3],NULL,0);
    index = (__u32)strtoul(argv[4],NULL,0);
    data = (__u32)strtoul(argv[5],NULL,0);
    WriteDictionaryEntry(0, nodeID, index, 0,sizeof(data), &data);
    printf("data written\n");
    f_can_close(busfd);
    break;

  default:
    printf("invalid number of arguements\n");
    help();
    return 0;
  }


return 0;
}

void printpacket(Message *m, int state)
{
  int i;
  extern proceed_info proceed_infos[];
  if(state>=0){
    int fc = GET_FUNCTION_CODE((*m));
    int ID = GET_NODE_ID((*m));
    printf("%s%-6.6s %2.2x %s",
	      state == STATE_Tx ? ">" : "<",
	      proceed_infos[fc].name,
	      ID,
	      m->rtr ? "Yes" : "No ");
    for ( i = 0; i < m->len;i++){
      printf("%2.2x ",m->data[i]);
    }
  } else {
    printf("Read Error (%d)",state);
  }
  
  
}









