/*Can4Open
linking functions between can4linux low level drivers and
the CanFestival CanOpen static libraries.
Nathan Z. Gustavson
ngustavson@emacinc.com

rev 0.1

emac.inc
10/8/02
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <sched.h>
#include <stdlib.h>
#include "Can.h"
#include "can4linux.h"
#include "Can4Open.h"
#include "CanOpener.h"
#include <sys/resource.h>
#include <sys/io.h>
#include <signal.h>


int Message_Handler(int bus_id);//the message handler from CanOpenMatic

logfunc txloggingfunc = NULL;
logfunc rxloggingfunc = NULL;
can_callback rxcallback = NULL;
sigset_t signals;
extern int busfd;
int wait = 0;/* blocking or non blocking IO*/
/*to use this it will have to be extern'd and modified
as it is in the example project Can4Opener. 
*/


#define AsyncLock() sigprocmask(SIG_BLOCK,&signals,NULL)

#define AsyncUnlock() sigprocmask(SIG_UNBLOCK,&signals,NULL)



/*blocking functions
these functions should be used with caution.
Since blocking a message can only leave room for one pending message, 
these should generally only be used in a test program.
These functions would be ok in a sychronous enviornment, where all 
incoming messages where single line returns to a request.
However using these in other enviornments can cause the message handler 
not to work properly.
*/
void BlockMessage(void){
AsyncLock();
}

void UnBlockMessage(void){
AsyncUnlock();
}


/*
if messages are blocked for a period of time
messages can become built up in the Can Fifos with no handler to
receive them.
This function can be used to clear them out.
It manually runs the Message handler.
This function should be used as a last resort, or as an error checking 
mechanism.
It would only be needed in an enviornment where BlockMessage was called
and left on during Asychronous transfers.
*/
void MessPickup()
{
int bus_id = 0;
AsyncLock();
while(Message_Handler(bus_id));
AsyncUnlock();
}



/*msgtoMessage
conversion of the canmsg_t message structure(can4linux)
to the Message structure of CanOpenMatic(CanOpen for linux)
*/
int msgtoMessage(Message *message,canmsg_t *msg_t)
{
memcpy(&message->data,&msg_t->data,sizeof(message->data));
message->cob_id.w = (unsigned short)msg_t->id;
message->len = (char)msg_t->length;
	
if(msg_t->flags&MSG_RTR)
  message->rtr=1;
else
  message->rtr=0;

return 0;
}

/*Messagetomsg
conversion the Message structure of CanOpenMatic   
to the canmsg_t message structure(can4linux)
*/
int Messagetomsg(canmsg_t *msg_t, Message *message)
{
if(message->rtr)
msg_t->flags = MSG_RTR;
else
msg_t->flags = 0;

msg_t->length = (int)message->len;

memcpy(&msg_t->data,&message->data,sizeof(msg_t->data));
msg_t->id = (unsigned long)message->cob_id.w;

return 0;
}


/*
f_can_receive
calls read instead of ioctl to 
get data from can4linux
and translates the data into a message structure

returns 0 on success
 */
int f_can_receive(int notused, Message *m){
	int res;
	canmsg_t rx;
	
	if(wait)
	  while(!(res=read(busfd,&rx,1)));
	else
	  res = read(busfd,&rx,1);
    
	msgtoMessage(m,&rx);
			
	if(rxloggingfunc!=NULL)
	  {
	  if(res)
	    rxloggingfunc(m,STATE_Rx);
	  }

	if(rxcallback!=NULL)
	  {
	  if(res)
	    rxcallback(m);
	  }


	return !res;
}

/*
f_can_callback

Automatically call a function when a message is received and pass it the
message.

the callback function is of type
void func(Message *)

optionally the callback function could be NULL
and an rxlogging function could be used as the callback.


*/


int f_can_callback(can_callback callback){ 
rxcallback = callback;
return 0;
}




/*
f_can_send
translates a message stucture into a canmsg_t structure.
Calls write instead of ioctl to 
send data to can4linux

returns 0 on success
*/
int f_can_send(int notused, Message *m){
	int res;
	canmsg_t tx;
       	Messagetomsg(&tx,m);
	
	if(wait)
	  while(!(res=write(busfd,&tx, 1))); 
	else
	  res = write(busfd,&tx,1);


	if(txloggingfunc!=NULL)
	   txloggingfunc(m, (res ? STATE_Tx : STATE_FAULT));
    	
       	return !res;
}




/*
int can_handler(void *unused)
{
fd_set read_fds;
int retval;
int bus_id = 0;

iopl(3);//change io privilage level, this must be run from root

setpriority(PRIO_PROCESS,0,-20);//jack up priority to speed up access time

signal(SIGKILL,SIG_DFL);//install kill handler if needed

FD_ZERO(&read_fds);
FD_SET(busfd, &read_fds);

while(1)
  {

    //printf("waiting for data in child process\n");
    retval = select(busfd+1,&read_fds,NULL,NULL,NULL);
    //go to sleep until a signal is rxd from the can ISR
    if(retval)//data is ready
		{
		 //printf("data received\n");
	         while(!Message_Handler(bus_id));
				   
	        }
    //printf("loop\n");
  }

_exit(0);

}
*/

int can_handler(void *unused)
{
int bus_id = 0;
while(!Message_Handler(bus_id));
return 0;
}


static void can_IOhandler(int signal){
AsyncLock();
can_handler(NULL);
AsyncUnlock();
}



int f_can_open(const char *device)
{
struct sigaction can_signal;
long oflags;
busfd = open(device,O_RDWR);

sigemptyset(&signals);
sigaddset(&signals, SIGIO);


can_signal.sa_handler = can_IOhandler;

sigaction(SIGIO, &can_signal,NULL); //install signal handler
fcntl(busfd, F_SETOWN,getpid()); //set signal ownership
oflags = fcntl(busfd, F_GETFL); //get current flags
fcntl(busfd,F_SETFL, oflags|FASYNC);//add FASYNC flag to them

return busfd;
}







int f_can_close(int fd){
 
//if(Can_Handler.ps)//kill the message handler process
//    kill(Can_Handler.ps,SIGKILL);

//if(Can_Handler.stack)
//  free(Can_Handler.stack);

  return close(fd);
}




