/*AsyncRx.c

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

11/07/02 

Description:
A small C program demonstrating how to use  canopen libraries 
receive callback

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <asm/types.h>
#include <unistd.h>
#include <curses.h>

#include "Can.h"
#include "CanOpenMatic.h"
#include "CanOpener.h"
#include "Can4Open.h"


void print_message(Message *);
int busfd;
int count=0;


int main()
{

busfd = f_can_open("/dev/can0");


f_can_callback(print_message);
  printf("callback installed on can0\n");


//getchar();
while(1)
pause();

f_can_close(busfd);

return 0;
}



void print_message(Message *m)
{
 int i;
  extern proceed_info proceed_infos[];

  //print out the message  

    int fc = GET_FUNCTION_CODE((*m));
    int ID = GET_NODE_ID((*m));
if(!count)
  {//add CRLF at beginning for stdios that require LF to enter data
printf("\n");
count=1;
  }
    printf("%-6.6s %2.2x %s",
      proceed_infos[fc].name,
	      ID,
	      m->rtr ? "RTR " : "No RTR ");
    for ( i = 0; i < m->len;i++){
      printf("%2.2x ",m->data[i]);
    }
  printf("\n");//newline
}



