/*AsyncRT.c

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

11/07/02 

Description:
A realtime C program demonstrating how to use  canopen libraries 
receive callback

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <asm/types.h>
#include <unistd.h>
#include <curses.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>
#include <signal.h>

#include "Can.h"
#include "CanOpenMatic.h"
#include "CanOpener.h"
#include "Can4Open.h"

//#include <rtai.h>
//#include <rtai_sched.h>
#define KEEP_STATIC_INLINE
#include <../lxrt/rtai_lxrt_user.h>
#include <rtai_lxrt.h>

//#include "clock.h"

void print_message(Message *);
void get_time(Message *);

int busfd;
int count=0;
int message=0;
RTIME cantime[100];
char data[100];

int main()
{
RT_TASK *ctsk;
struct sched_param mysched;
unsigned long ctsk_name = nam2num("TIM");
int i;

printf("setting up scheduler\n");

mysched.sched_priority = sched_get_priority_max(SCHED_FIFO) - 1;
	if( sched_setscheduler( 0, SCHED_FIFO, &mysched ) == -1 ) {
		printf("ERROR IN SETTING THE POSIX SCHEDULER\n");
		exit(1);
 	}       
	mlockall(MCL_CURRENT | MCL_FUTURE);

printf("initializing task\n");





if (!(ctsk = rt_task_init(ctsk_name, 0, 0, 0))) {
printf("CANNOT INIT SRV TASK\n");
exit(2);
}

printf("task initialized\n");

busfd = f_can_open("/dev/can0");

printf("device opened\n");

f_can_callback(get_time);
  printf("callback installed on can0\n");

cantime[message++] = rt_get_cpu_time_ns();

ReadDictionaryEntry(0, 1, 0x6403, 0, data);


//getchar();
//while(1)

//for(i=0;i<=4;i++)
//pause();

printf("Read Dictionary Entry Called at %llu\n",cantime[0]); 

for(i=1;i<message;i++)
printf("time =  %llu\n",cantime[i]);

rt_task_delete(ctsk);
f_can_close(busfd);

return 0;
}


void get_time(Message *m){

  /*
if(!count)
  {//add CRLF at beginning for stdios that require LF to enter data
printf("\n");
count=1;
  }

printf("get time\n");
*/


cantime[message++] = rt_get_cpu_time_ns();
}


void print_message(Message *m)
{
 int i;
  extern proceed_info proceed_infos[];

  //print out the message  

    int fc = GET_FUNCTION_CODE((*m));
    int ID = GET_NODE_ID((*m));
if(!count)
  {//add CRLF at beginning for stdios that require LF to enter data
printf("\n");
count=1;
  }
    printf("%-6.6s %2.2x %s",
      proceed_infos[fc].name,
	      ID,
	      m->rtr ? "RTR " : "No RTR ");
    for ( i = 0; i < m->len;i++){
      printf("%2.2x ",m->data[i]);
    }
//printf("  time =  %llu\n",rt_get_cpu_time_ns());

  printf("\n");//newline
}



