/*Async2.c

Nathan Z. Gustavson
ngustavson@emacinc.com
Emac.inc
www.emacinc.com

12/20/02 



A c program demonstrating the basic asychronous notification abilities
of the hardware layer

usage:

async2 can0

displays all messages received by can0 asychronously

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <asm/types.h>
#include <unistd.h>
#include <curses.h>
#include <signal.h>

#include "Can.h"
#include "CanOpenMatic.h"
#include "CanOpener.h"
#include "Can4Open.h"

void print_message(Message *);

int busfd;
int count=0;
int mcount =0;
Message messages[100];

static void can_display(int signal){
Message m;
sigset_t signals;

sigemptyset(&signals);
sigaddset(&signals, SIGIO);

//sigprocmask(SIG_BLOCK,&signals,NULL);

//printf("asychronous signal received\n");

if(f_can_receive(0,&m))
  {
printf("couldn't read from device\n");
return;
  }

//messages[mcount++] = m;
print_message(&m);

//sigprocmask(SIG_UNBLOCK,&signals,NULL);
}




int main(int argc, char *argv[])
{
int fd = 0;
long oflags;
struct sigaction can_signal;
//int i;

if(argc!=2)
  {
printf("invalid number of arguements\n");
return -1;
  }



if((fd=open(argv[1],O_RDWR))<=0)
  {
    printf("couldn't open %s\n",argv[1]);
    return -1;
  }
busfd = fd;

can_signal.sa_handler = can_display;

sigaction(SIGIO, &can_signal,NULL); //install signal handler
fcntl(fd, F_SETOWN,getpid()); //set signal ownership
oflags = fcntl(fd, F_GETFL); //get current flags
fcntl(fd,F_SETFL, oflags|FASYNC);//add FASYNC flag to them

while(1);

//getchar();

//for(i=0;i<mcount;i++)
//  print_message(&messages[i]);


close(fd);

return 0;
}


void print_message(Message *m)
{
 int i;
  extern proceed_info proceed_infos[];

  //print out the message  

    int fc = GET_FUNCTION_CODE((*m));
    int ID = GET_NODE_ID((*m));

if(!count)
  {//add CRLF at beginning for stdios that require LF to enter data
printf("\n");
count=1;
  }
    printf("%-6.6s %2.2x %s",
      proceed_infos[fc].name,
	      ID,
	      m->rtr ? "RTR " : "No RTR ");
    for ( i = 0; i < m->len;i++){
      printf("%2.2x ",m->data[i]);
    }
  printf("\n");//newline
}

